/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.AbstractPiece;
import net.sf.paperclips.PageNumber;
import net.sf.paperclips.PageNumberFormat;
import net.sf.paperclips.PageNumberIterator;
import net.sf.paperclips.TextStyle;
import net.sf.paperclips.internal.ResourcePool;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class PageNumberPiece
extends AbstractPiece {
    private final PageNumber pageNumber;
    private final TextStyle textStyle;
    private final PageNumberFormat format;

    PageNumberPiece(PageNumberIterator iter, Point size) {
        super(iter, size);
        this.pageNumber = iter.pageNumber;
        this.textStyle = iter.textStyle;
        this.format = iter.format;
    }

    public void paint(GC gc, int x, int y) {
        Font oldFont = gc.getFont();
        Color oldForeground = gc.getForeground();
        Point size = this.getSize();
        try {
            ResourcePool resources = ResourcePool.forDevice(this.device);
            gc.setFont(resources.getFont(this.textStyle.getFontData()));
            gc.setForeground(resources.getColor(this.textStyle.getForeground()));
            String text = this.format.format(this.pageNumber);
            gc.drawText(text, x + this.getHorzAlignmentOffset(gc.textExtent((String)text).x, size.x), y, true);
        }
        finally {
            gc.setFont(oldFont);
            gc.setForeground(oldForeground);
        }
    }

    private int getHorzAlignmentOffset(int textWidth, int totalWidth) {
        int offset = 0;
        switch (this.textStyle.getAlignment()) {
            case 0x1000000: {
                offset = (totalWidth - textWidth) / 2;
                break;
            }
            case 131072: {
                offset = totalWidth - textWidth;
            }
        }
        return offset;
    }

    public void dispose() {
    }
}

